function Component()
{
   installer.installationStarted.connect(this, Component.prototype.onInstallationStarted);
}

Component.prototype.onInstallationStarted = function()
{
    if (component.updateRequested() || component.installationRequested()) 
    {
        if (installer.value("os") == "win")
        {
          component.installerbaseBinaryPath = "@TargetDir@/tempmaintenancetool.exe";
        }
        else if (installer.value("os") == "x11" || installer.value("os") == "mac")
        {
          component.installerbaseBinaryPath = "@TargetDir@/.tempmaintenancetool";
        }
        installer.setInstallerBaseBinary(component.installerbaseBinaryPath);
        // update resource file
        var updateResourceFilePath = "@TargetDir@/update.rcc";
        var normalizedUpdateResourceFilePath = updateResourceFilePath.replace(/@TargetDir@/, installer.value("TargetDir"));
        print("Updating resource file: " + normalizedUpdateResourceFilePath);
        installer.setValue("DefaultResourceReplacement", normalizedUpdateResourceFilePath);
    }
}
Component.prototype.createOperationsForArchive = function(archive)
{
    //installer.performOperation in older versions of the installer framework don't supports @TargetDir@
    var normalizedInstallerbaseBinaryPath = component.installerbaseBinaryPath.replace(/@TargetDir@/,installer.value("TargetDir"));
    installer.performOperation("SimpleMoveFile",new Array(normalizedInstallerbaseBinaryPath, normalizedInstallerbaseBinaryPath + "_backup"));
    component.createOperationsForArchive(archive);
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations and afterwards set some registry settings (unpacking ...)
    component.createOperations();
}